/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.ArrayList;
import java.util.List;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.UpgradableEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.HeatGeneratorRecipe;
import me.jddev0.ep.screen.HeatGeneratorMenu;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class HeatGeneratorBlockEntity
extends UpgradableEnergyStorageBlockEntity<EnergizedPowerEnergyStorage> {
    public static final double ENERGY_PRODUCTION_MULTIPLIER = ModConfigs.COMMON_HEAT_GENERATOR_ENERGY_PRODUCTION_MULTIPLIER.getValue();

    public HeatGeneratorBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(EPBlockEntities.HEAT_GENERATOR_ENTITY, blockPos, blockState, "heat_generator", ModConfigs.COMMON_HEAT_GENERATOR_CAPACITY.getValue(), ModConfigs.COMMON_HEAT_GENERATOR_TRANSFER_RATE.getValue(), UpgradeModuleModifier.ENERGY_CAPACITY);
    }

    @Override
    protected EnergizedPowerEnergyStorage initEnergyStorage() {
        return new EnergizedPowerEnergyStorage(this.baseEnergyCapacity, this.baseEnergyCapacity, this.baseEnergyCapacity){

            @Override
            public long getCapacity() {
                return Math.max(1L, (long)Math.ceil((double)this.capacity * HeatGeneratorBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            protected void onFinalCommit() {
                HeatGeneratorBlockEntity.this.method_5431();
                HeatGeneratorBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage() {
        return new EnergizedPowerLimitingEnergyStorage(this.energyStorage, 0L, this.baseEnergyTransferRate){

            @Override
            public long getMaxExtract() {
                return Math.max(1L, (long)Math.ceil((double)this.maxExtract * HeatGeneratorBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }
        };
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        return new HeatGeneratorMenu(id, this, inventory, this.upgradeModuleInventory);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, HeatGeneratorBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        List recipes = level.method_8433().method_30027((class_3956)HeatGeneratorRecipe.Type.INSTANCE);
        long productionSum = 0L;
        block5: for (class_2350 direction : class_2350.values()) {
            class_2338 checkPos = blockPos.method_10093(direction);
            class_3610 fluidState = level.method_8316(checkPos);
            for (class_8786 recipe : recipes) {
                for (class_3611 fluid : ((HeatGeneratorRecipe)recipe.comp_1933()).getInput()) {
                    if (!fluidState.method_39360(fluid)) continue;
                    productionSum += ((HeatGeneratorRecipe)recipe.comp_1933()).getEnergyProduction();
                    continue block5;
                }
            }
        }
        if (productionSum > 0L) {
            productionSum = (long)((double)productionSum * ENERGY_PRODUCTION_MULTIPLIER);
            try (Transaction transaction = Transaction.openOuter();){
                ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).insert(productionSum, (TransactionContext)transaction);
                transaction.commit();
            }
        }
        HeatGeneratorBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    private static void transferEnergy(class_1937 level, class_2338 blockPos, class_2680 state, HeatGeneratorBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        ArrayList<EnergyStorage> consumerItems = new ArrayList<EnergyStorage>();
        ArrayList<Long> consumerEnergyValues = new ArrayList<Long>();
        long consumptionSum = 0L;
        for (class_2350 direction : class_2350.values()) {
            EnergyStorage limitingEnergyStorage;
            class_2338 testPos = blockPos.method_10093(direction);
            class_2586 testBlockEntity = level.method_8321(testPos);
            if (testBlockEntity == null || (limitingEnergyStorage = (EnergyStorage)EnergyStorage.SIDED.find(level, testPos, (Object)direction.method_10153())) == null || !limitingEnergyStorage.supportsInsertion()) continue;
            try (Transaction transaction = Transaction.openOuter();){
                long received = limitingEnergyStorage.insert(Math.min(blockEntity.limitingEnergyStorage.getMaxExtract(), ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount()), (TransactionContext)transaction);
                if (received <= 0L) continue;
                consumptionSum += received;
                consumerItems.add(limitingEnergyStorage);
                consumerEnergyValues.add(received);
            }
        }
        ArrayList<Long> consumerEnergyDistributed = new ArrayList<Long>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0L);
        }
        long consumptionLeft = Math.min(blockEntity.limitingEnergyStorage.getMaxExtract(), Math.min(((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount(), consumptionSum));
        try (Transaction transaction = Transaction.openOuter();){
            ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).extract(consumptionLeft, (TransactionContext)transaction);
            transaction.commit();
        }
        int divisor = consumerItems.size();
        block18: while (consumptionLeft > 0L) {
            long consumptionPerConsumer = consumptionLeft / (long)divisor;
            if (consumptionPerConsumer == 0L) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / (long)divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                long consumptionDistributed = (Long)consumerEnergyDistributed.get(i);
                long consumptionOfConsumerLeft = (Long)consumerEnergyValues.get(i) - consumptionDistributed;
                long consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0L) break block18;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            long energy = (Long)consumerEnergyDistributed.get(i);
            if (energy <= 0L) continue;
            try (Transaction transaction = Transaction.openOuter();){
                ((EnergyStorage)consumerItems.get(i)).insert(energy, (TransactionContext)transaction);
                transaction.commit();
                continue;
            }
        }
    }
}

